#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// genuary 2025 #19Mod01.fsh  by    phreax 
//https://www.shadertoy.com/view/l3tBz2
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Fork of "[phreax] trippy torus" by phreax. https://shadertoy.com/view/wlSSDD
// 2025-01-21 05:31:11

#define SIN(x) (.5+.5*sin(x))
#define rot(x) mat2(cos(x), -sin(x), sin(x), cos(x))
#define sabsk(x, k) sqrt(x * x + k * k)
float tt;

float map(vec3 p) {

     float len = length(p);
     p.yz *= rot(p.x*.2+.5*sin(tt)+.3*len);
     p.x = mix(p.x, sin(8.*p.x)*0.2, SIN(2.*tt)); 
    // p.z = mix(p.z, sin(8.*p.z)*0.2, .5+.5*cos(2.*tt)); 
     float d = (length(vec2(length(p.xz) - .9, p.y)) - .8); 
     
     return d;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - .5*iResolution.xy)/iResolution.y;

    uv = uv.yx;
    tt = (iTime+3.8) * 0.5;
    float len = length(uv);
    uv *= 1.2;
  //  uv *= rot((1.-len)*3.*sin(tt));
    uv = sabsk(uv, .3) - .2 + .1*SIN(.5*tt);
    uv *= rot(len*.8+.3*tt);
    uv = sabsk(uv, .3) - .5 + .1*SIN(.5*tt);
  
    
    vec3 ro = vec3(0, 1.4, -.1);
    vec3 lookat = vec3(0);
    float zoom = mix(0.3, 0.8, sin(tt)*.5+.5);
    vec3  lp = vec3(0, 3., -1.);
    

    zoom = 1.-.4*(len);
    // camera system
    vec3 f = normalize(lookat - ro),  // forward vector
         r = normalize(cross(vec3(0, 1, 0), f)), // right vector
         u = cross(f, r), // up vector
         c = ro + f * zoom, // center of virtual screen
         i = c + uv.x * r + uv.y * u, // intersection with screen
         rd = normalize(i - ro);  // ray direction
    
    
    // raymarch
    float s, d;
    vec3 p = vec3 (0);
    
    for(int i=0; i<100; i++) {
        p = ro + rd * s;
        d = map(p);
        if(d < 0.001 || s > 3.) break;
        s += d;
    }
    
    vec3 col = vec3(0);
    if(d < 0.001) {   
        vec2 e = vec2(0.0035, -0.0035);
        vec3 n = normalize( e.xyy*map(p+e.xyy) + e.yyx*map(p+e.yyx) +
                    e.yxy*map(p+e.yxy) + e.xxx*map(p+e.xxx));
                    
        vec3 l = normalize(lp-p);
        float dif = max(dot(n, l), .0);
        
        float x = atan(p.x, p.z)*.4;
        float y = atan(length(p.xz*4.) - 1.0, p.y) + tt*.5;
        
        float bands = sin(15.*y);
        float ripples = smoothstep(-.1, 0.11, sin(( 30.*x+tt )*3.));
        float b1 = smoothstep(-.2, .21, bands);
		float b2 = smoothstep(-.1, .11, bands-0.3);
        
        float m = b1*(1.-b2);
        m = max(m, ripples*b2);
        col += m;
        
       /* if(mod(15.*y, 5.) > 1.) {
            col *= vec3(0.220,1.000,0.988)*bands;
        }
        
        else if(mod(15.*y, 5.) < 1.) {
            col *= vec3(1.000,0.792,0.220)*bands;
        }*/
        col *= mix(1., dif, .2);
    }
    
    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

